@extends("admin.layouts.app")

@section("style")
	
@endsection

@section("wrapper")
<!--start page wrapper -->
<div class="page-wrapper">
	<div class="page-content">
		<!--breadcrumb-->
			<x-admin.breadcrumb menu="Settings" page="Manage Roles"/>
		<!--end breadcrumb-->
		
		<div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
			<h6 class="mb-0 text-uppercase">List Roles</h6>
			<div class="ms-auto">
				<div class="btn-group">
					<button type="button" class="btn btn-primary rounded" href="javascript:void(0)" id="createNewRole">
						<i class="lni lni-circle-plus"></i> Add Role
					</button>
				</div>
			</div>
		</div>
		<hr/>

		<div class="card">
			<div class="card-body">
				<div class="table-responsive">
					<table id="data-table" class="table" width="100%">
						<thead class="table-light">
							<tr>
								<th style="width:5%;">#</th>
								<th>Roles</th>
								<th style="width:10%;">Action</th>
							</tr>
						</thead>
						<tbody></tbody>
					</table>
				</div>
			</div>
		</div>
	</div>

	<div class="modal" id="role-modal" tabindex="-1">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title" id="modal-heading">Create New Role</h5>
					<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
				</div>
				<div class="modal-body">
					<form id="roleForm" name="roleForm" class="form-horizontal">
						<input type="hidden" name="role_id" id="role_id">
						<div class="mb-3">
							<label for="role_name" class="form-label">Role Name</label>
							<input type="text" class="form-control" id="role_name" name="role_name" placeholder="Enter role name">
							<div class="invalid-feedback invalid-role-name"></div>
						</div>
					</form>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-success rounded" href="javascript:void(0)" id="saveBtn"><i class="lni lni-save"></i>Save</button>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection

@section("script")
<script>
	$(function () {
			$.ajaxSetup({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				}
			});

			let table = $('#data-table').DataTable({
				processing: true,
				serverSide: true,
				ajax: "{{ route('admin.role.index') }}",
				columns: [
					{data: 'DT_RowIndex', name: 'DT_RowIndex', orderable: false, searchable: false},
					{data: 'role_name', name: 'role_name'},
					{data: 'action', name: 'action', orderable: false, searchable: false},
				],
			});

			$('#createNewRole').click(function () {
				$('#role_id').val('');
				$('#saveBtn').html("<i class=\"lni lni-save\"></i> Save");
				$('#roleForm').trigger("reset");
				$('#role-modal').modal('show');
				$('#role_name').focus();
			});

			$('#saveBtn').click(function (e) {
				e.preventDefault();

				$.ajax({
				data: $('#roleForm').serialize(),
				url: "{{ route('admin.role.store') }}",
				type: "POST",
				dataType: 'json',
				success: function (res) {
					if(res.status == 400){
						$('.invalid-role-name').text('');

						if(res.errors.role_name){
							$('.invalid-role-name').text(res.errors.role_name);
						}
					}

					if(res.status == 200){
						$('.invalid-role-name').text('');
						$('#roleForm').trigger("reset");
						$('#role-modal').modal('hide');
						table.draw();
						if(res.errors.created_at === res.errors.updated_at){
							swal("Added", "New role added successfully", "success");
						}else{
							swal("Updated", "Role updated successfully", "success");
						}
						
					}

					
				},
				error: function (data) {
					console.log('Error:', data);
				}
			});
		});

		$('body').on('click', '.editRole', function () {
			let role_id = $(this).data('id');
			$.get("{{ route('admin.role.index') }}" +'/' + role_id +'/edit', function (data) {
				$('#modal-heading').html("Edit Role");
				$('#saveBtn').html("<i class=\"lni lni-save\"></i> Update");
				$('#role-modal').modal('show');
				$('#role_id').val(data.id);
				$('#role_name').val(data.role_name);
			})
		});

		$('body').on('click', '.deleteRole', function(){
			let role_id = $(this).data("id");
			console.log('clicked...')
			swal({
				title: "Are you sure to delete this role?",
				text: "It will gone forever.",
				icon: "warning",
				buttons: true,
				dangerMode: true,
			}).then((willDelete) =>{
				if(willDelete){
					$.ajax({
						type: "DELETE",
						url: "{{ url('admin/role') }}"+'/'+role_id,
						data: {id: role_id},
						success: function (res) {
							table.draw();
							swal("Deleted", "Role deleted successfully", "success");
						},
						error: function (data) {
							console.log('Error:', data);
						}
					});
				}
			})
		});

	})
</script>
@endsection

